#!/bin/bash
#gcsf@nowhere
#IDSECCONF 2013

export PATH=$PATH:/sbin:/usr/sbin:.
#Configure
BR="br0"
BR1="br1"
TAP="tap0"
ETH="eth1"
MIRROR1="tap1"
REMOTE="tap2"
MIRROR2="tap3"
IPADDR="192.168.137.103/24"
REMOTEIP="222.0.5.10/24"
BR1IP="20.20.20.1/24"
GWADDR="192.168.137.1"
LOGIN="anto"
#End Configuration

echo "[+] Configuring Network"
brctl addbr $BR
ip l s dev $BR up

brctl addbr $BR1
ip l s dev $BR1 up

tunctl -t $TAP -u $LOGIN
ip l s dev $TAP up

tunctl -t $MIRROR1 -u $LOGIN
ip l s dev $MIRROR1 up
ifconfig $MIRROR1 0.0.0.0 promisc

tunctl -t $MIRROR2 -u $LOGIN
ip l s dev $MIRROR2 up
ifconfig $MIRROR2 0.0.0.0 promisc

tunctl -t $REMOTE -u $LOGIN
ip l s dev $REMOTE up
ip a a $REMOTEIP dev $REMOTE

brctl addif $BR $TAP
brctl addif $BR $ETH

brctl addif $BR1 $MIRROR1
brctl addif $BR1 $MIRROR2
ip a a $BR1IP dev $BR1

ifconfig $ETH 0.0.0.0 promisc
ip a a $IPADDR dev $BR
ip ro a default via $GWADDR
echo "[+] Done"
